(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    114147,       3165]
NotebookOptionsPosition[    102511,       2888]
NotebookOutlinePosition[    102898,       2904]
CellTagsIndexPosition[    102855,       2901]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 203 - Multivariable Calculus", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 
  3.713235386162277*^9}},ExpressionUUID->"3eff84e4-7dc3-473c-9d5f-\
5004e7960755"],

Cell[CellGroupData[{

Cell[TextData[{
 "Lines and Planes\n",
 StyleBox["September 13, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}, {3.7136367302253275`*^9, 3.7136367303689313`*^9}, {
  3.7136390134313707`*^9, 3.713639019486205*^9}, {3.7138289066862593`*^9, 
  3.713828911468053*^9}, {3.714057515975712*^9, 3.7140575196396585`*^9}, {
  3.714251590010911*^9, 
  3.7142515958496876`*^9}},ExpressionUUID->"4ca45a66-6d29-4841-83ec-\
d372e9019604"],

Cell["\<\
This link has a list of keyboard shortcuts for Mathematica. This can make \
entering integrals, derivatives, and other things easier! \
\>", "Text",
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 3.713465718323245*^9}, {3.7134658334571447`*^9, 
  3.713465872458172*^9}},ExpressionUUID->"76986328-9708-4592-8069-\
c192c864c775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Keyboard Shortcuts\>\"", ",", 
   "\"\<http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html\>\""}], "]"}]], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 
  3.7134657576928744`*^9}},ExpressionUUID->"f1b73c6d-03af-4e1c-b0a7-\
3c3a9a455888"],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Keyboard Shortcuts\"\>", True->
    StyleBox["\<\"Keyboard Shortcuts\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaseStyle->{"Hyperlink"},
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html"], None},
   ButtonNote->
    "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html"],
  Annotation[#, 
   "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.713465760187833*^9, 3.7136407538491297`*^9, 
  3.7138327273600025`*^9, 3.714063605757433*^9, 
  3.7146994255154314`*^9},ExpressionUUID->"349dc998-50ff-45d9-9c2c-\
a890248307b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"03899cad-2d7f-4aa5-9757-\
7093b5aa4e28"],

Cell[TextData[{
 "Find an equation for the line passing though the given point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "5", ",", "4"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9b5217b4-afc7-452c-bd06-64c1798a88c2"],
 " and parallel to the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"2", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"4", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6cb21436-fecc-4326-9534-98303b1f23fd"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}, {3.7138289305891924`*^9, 3.713828982326439*^9}, {
   3.7140575793278756`*^9, 3.714057604512898*^9}, {3.714251724130576*^9, 
   3.7142517519477997`*^9}, {3.7142583209982357`*^9, 
   3.7142583534768305`*^9}},ExpressionUUID->"6b418206-14d1-46aa-808a-\
8cbb9f5f0f50"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714698439959632*^9, 
  3.7146984419649806`*^9}},ExpressionUUID->"4bf7bcf4-5476-4255-a4c3-\
7b2a0d770634"],

Cell[TextData[{
 "A line is given in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{"P", "+", 
     RowBox[{"t", " ", 
      OverscriptBox["v", "\[RightVector]"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d072ed1b-486e-40ad-9ccf-9e5150ef3012"],
 " where ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "36b304a7-9a97-4a3e-828f-745200920068"],
 " is a point on the line and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "86e4b22b-89f4-4730-b694-7c04f46850ae"],
 " is a vector parallel to (in the same direction as) the line:"
}], "Text",
 CellChangeTimes->{{3.7146984928351603`*^9, 
  3.71469854307308*^9}},ExpressionUUID->"4999fec4-8695-4222-a2a1-\
7054add3539a"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "5", ",", "4"}], "\[RightAngleBracket]"}], 
     "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"2", ",", "4", ",", "0"}], "\[RightAngleBracket]"}]}]}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"2", "t"}]}], ",", 
      RowBox[{"5", "+", 
       RowBox[{"4", "t"}]}], ",", "4"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"b708ae49-0733-4e1e-b38e-a8d36821934a"]], \
"Text",
 CellChangeTimes->{{3.714698439959632*^9, 3.714698484624491*^9}},
 TextAlignment->Center,ExpressionUUID->"bc68ab0f-4e76-4c06-8431-8e7c6bb878b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Find an equation for the line segment between the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "=", 
    RowBox[{"(", 
     RowBox[{"0", ",", "4", ",", "3"}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"20465de0-3a15-4644-a3b5-f013529a0225"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2", ",", "5"}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"d647a7bf-8f3f-481d-b92e-204d8dc50f8f"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}, {3.713829558030411*^9, 3.713829601921364*^9}, {
   3.7140577282741427`*^9, 3.714057735396927*^9}, {3.7142518564834394`*^9, 
   3.7142518840124702`*^9}, {3.7142575828801985`*^9, 3.714257595992709*^9}, {
   3.7146985883784647`*^9, 
   3.714698593194729*^9}},ExpressionUUID->"44e048d0-9c5e-4858-a8ac-\
e93277be3c9e"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714698558473095*^9, 
  3.71469856009921*^9}},ExpressionUUID->"3a6c5313-a2da-44a5-9d93-\
70c3f1d13719"],

Cell[TextData[{
 "A line segment with start time ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d560f169-ef1e-4101-8797-109c6e4355a1"],
 " and end time ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a87b9feb-c690-44f5-9ab3-18a989cfe335"],
 " between the points ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "512dbd83-c3d1-4f6c-81ca-ef7f79de9cc2"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "092480f0-4aa7-4b65-b5e7-70985a7a643a"],
 " is computed as"
}], "Text",
 CellChangeTimes->{{3.714698558473095*^9, 3.7146986529682245`*^9}, {
  3.714698710691065*^9, 
  3.7146987375526147`*^9}},ExpressionUUID->"76255cbe-75ce-4d23-8269-\
87ea14953e78"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "t"}], ")"}], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"0", ",", "4", ",", "3"}], "\[RightAngleBracket]"}]}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2", ",", "5"}], 
       "\[RightAngleBracket]"}]}]}]}], ",", " ", 
   RowBox[{"0", "\[LessEqual]", "t", " ", "\[LessEqual]", " ", "1"}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"fde6bb19-c2d9-44df-a520-b4a0b28efd65"]], \
"Text",
 CellChangeTimes->{{3.714698558473095*^9, 3.7146986529682245`*^9}, {
  3.714698710691065*^9, 3.7146987918127623`*^9}},
 TextAlignment->Center,ExpressionUUID->"efcbeef3-675a-48f7-a453-9d0214f17f1f"],

Cell["(This isn\[CloseCurlyQuote]t the only possibility, but it is the \
easiest.)", "Text",
 CellChangeTimes->{{3.714698558473095*^9, 3.7146986529682245`*^9}, {
  3.714698710691065*^9, 
  3.714698808259987*^9}},ExpressionUUID->"71f4c264-fafb-417d-93b5-\
eb029b4c81d3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell[TextData[{
 "If we have a line with vector equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"x", "(", "t", ")"}], ",", 
      RowBox[{"y", "(", "t", ")"}], ",", 
      RowBox[{"z", "(", "t", ")"}]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "630242ee-bf41-472e-abc8-2f2cd9983ea9"],
 ", the ",
 StyleBox["parametric equations",
  FontSlant->"Italic"],
 " for the line is given by just writing the three components on separate \
lines:"
}], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7138326110842867`*^9, 
   3.7138326912646074`*^9}, {3.7138723819566164`*^9, 
   3.7138723935333405`*^9}, {3.7140589414859295`*^9, 3.7140589627666883`*^9}, 
   3.7140589981439013`*^9, {3.714251939812981*^9, 
   3.7142520192698393`*^9}},ExpressionUUID->"7da010b4-d40f-49bb-beab-\
91f2f0dea101"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"x", "=", 
          RowBox[{"x", "(", "t", ")"}]}], "\[LineSeparator]", 
         RowBox[{"y", "=", 
          RowBox[{"y", "(", "t", ")"}]}], "\[LineSeparator]", 
         RowBox[{"z", "=", 
          RowBox[{"z", "(", "t", ")"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"d22bf5e4-48da-4c41-8109-ab08731b9343"]], \
"Text",
 CellChangeTimes->{{3.7142520448698807`*^9, 
  3.7142520599410796`*^9}},ExpressionUUID->"afc78e92-d5bc-4075-a231-\
33876a943f9b"],

Cell[TextData[{
 "For example, if we have the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "t"}], ",", 
      RowBox[{"3", "t"}], ",", 
      RowBox[{"4", "+", "t"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f3f6dab5-2f35-4c80-a8ff-93f569ac1893"],
 ", the parametric equations for the line would be given by"
}], "Text",
 CellChangeTimes->{{3.7142520662172623`*^9, 
  3.7142521193735485`*^9}},ExpressionUUID->"d2612c39-f378-456f-ab89-\
1e00c1c1907d"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"x", "=", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "t"}]}], "\[LineSeparator]", 
         RowBox[{"y", "=", 
          RowBox[{"3", "t"}]}], "\[LineSeparator]", 
         RowBox[{"z", "=", 
          RowBox[{"4", "+", "t"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"104d2aab-b421-472e-b953-76909f1d2557"]], \
"Text",
 CellChangeTimes->{{3.7142521236763315`*^9, 
  3.7142521352064204`*^9}},ExpressionUUID->"8659541b-cc59-4b77-9a69-\
bb7418e7b483"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Find a set of parametric equations for the line which passes \
through the point ", "ItemNumbered"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], ",", " ", "5", ",", " ", "2"}], ")"}], 
   TraditionalForm]], "ItemNumbered",
  FormatType->"TraditionalForm",ExpressionUUID->
  "7091e958-43c7-4b39-ab2b-613f13de46ca"], "ItemNumbered"],
 StyleBox[" and is parallel to the ", "ItemNumbered"],
 StyleBox[Cell[BoxData[
  FormBox["xy", TraditionalForm]], "ItemNumbered",
  FormatType->"TraditionalForm",ExpressionUUID->
  "029ca5fc-6852-4f9a-9f8f-29368f9fa9c2"], "ItemNumbered"],
 StyleBox["-plane and the ", "ItemNumbered"],
 StyleBox[Cell[BoxData[
  FormBox["yz", TraditionalForm]], "ItemNumbered",
  FormatType->"TraditionalForm",ExpressionUUID->
  "ce8622fc-efe7-4a61-98a3-6478950e3820"], "ItemNumbered"],
 StyleBox["-plane.", "ItemNumbered"]
}], "ItemNumbered",
 CellChangeTimes->{{3.714252278735142*^9, 3.7142522799997807`*^9}, 
   3.7142523339663086`*^9},ExpressionUUID->"cfd04572-998f-4f35-af46-\
2be8b5b2acfb"],

Cell[TextData[{
 StyleBox["Find a set of parametric equations for the line which passes \
through the point ", "ItemNumbered"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "3", ",", "4"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6e2e3cba-bc01-4833-ad0a-9670e77ea2e7"],
 " and is perpendicular to the plane given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"3", "x"}], "+", 
     RowBox[{"2", "y"}], "-", "z"}], "=", "6"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "72296b67-6399-4040-bda9-f34b15dc3f52"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714252278735142*^9, 
  3.7142523799113398`*^9}},ExpressionUUID->"f6ad4ebf-4895-4d71-92a3-\
0624555179e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714698855819373*^9, 
  3.7146988580978117`*^9}},ExpressionUUID->"d56d0594-95a5-4282-9b1a-\
dacc59432eac"],

Cell[CellGroupData[{

Cell[TextData[{
 "Since the line is parallel to both planes, it is perpendicular to the \
normal vector of both planes. A normal vector to the ",
 Cell[BoxData[
  FormBox["xy", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "df8c1e49-d9e5-4b3e-9d88-a080809ba2dd"],
 "-plane is ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["k", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "53c7bd8c-bb00-4af6-b485-7afb56b245e9"],
 " and a normal vector to the ",
 Cell[BoxData[
  FormBox["yz", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "dbb54940-f45a-4d33-87de-d1fbb0ec460a"],
 "-plane is ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["i", "^"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a73a7f57-5366-4502-8f61-69d4c341e25c"],
 ", so the direction of the line can be given as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["k", "^"], "\[Cross]", 
     OverscriptBox["i", "^"]}], "=", 
    OverscriptBox["j", "^"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e5631eb0-4b09-4041-86b6-b81a9c83e66b"],
 ", and so the equation is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "5", ",", "2"}], "\[RightAngleBracket]"}], 
      "+", 
      RowBox[{"t", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"0", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}]}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"5", "+", "t"}], ",", "2"}], "\[RightAngleBracket]"}], " "}]}],
    TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3b9e8bca-7354-4f22-a1ba-577077b60674"],
 " which has parametric equations: ",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{"x", "=", 
       RowBox[{"-", "4"}]}]},
     {
      RowBox[{
       RowBox[{"y", "=", 
        RowBox[{"5", "+", "t"}]}], "\[LineSeparator]", 
       RowBox[{"z", "=", "2"}]}]}
    }], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d1df3c42-fb2d-4a90-969f-7df9043a8982"]
}], "ItemNumbered",
 CellChangeTimes->{{3.714698855819373*^9, 3.714699035774297*^9}, {
  3.7146991089903755`*^9, 
  3.714699150664324*^9}},ExpressionUUID->"96f8c91c-aa32-4324-b32f-\
2f9b56165e21"],

Cell[TextData[{
 "Since the line is perpendicular to the plane, it is in the same direction \
as the normal vector to the plane. The normal vector to the plane is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["n", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", "2", ",", 
      RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0dc448f6-7d6e-4ac5-b097-2801e3cdad02"],
 ", so we can construct the line: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"2", ",", "3", ",", "4"}], "\[RightAngleBracket]"}], "+", 
      RowBox[{"t", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}]}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"2", "+", 
        RowBox[{"3", "t"}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"2", "t"}]}], ",", 
       RowBox[{"4", "-", "t"}]}], "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0944e2fc-b132-40a5-9f4a-6ed11cda2a55"],
 " which has parametric equations: ",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{"x", "=", 
       RowBox[{"2", "+", 
        RowBox[{"3", "t"}]}]}]},
     {
      RowBox[{"y", "=", 
       RowBox[{"3", "+", 
        RowBox[{"2", "t"}]}]}]},
     {
      RowBox[{"z", "=", 
       RowBox[{"4", "-", "t"}]}]}
    }], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "dfdf2598-c7c1-4d78-8a24-9d7faf873b19"]
}], "ItemNumbered",
 CellChangeTimes->{{3.714698855819373*^9, 3.714699035774297*^9}, {
  3.7146991089903755`*^9, 
  3.7146992925760584`*^9}},ExpressionUUID->"4b019e64-32dc-47ae-b96d-\
ec24d5de2ecc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 3.7132360046164513`*^9}, {
  3.7142519994689074`*^9, 
  3.714252000372249*^9}},ExpressionUUID->"62b50a9e-7116-4577-a2ef-\
50a12b356e7b"],

Cell["\<\
Determine whether the following pairs of lines are parallel, intersecting, or \
skew. If the lines intersect, give the point of intersection and the exact \
angle between them.\
\>", "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 3.7136515819870415`*^9}, {3.713833128184634*^9, 
   3.713833157380231*^9}, {3.7140591051033754`*^9, 3.7140591641839914`*^9}, {
   3.714060409067382*^9, 3.7140604184432797`*^9}, {3.71425294893425*^9, 
   3.714253001774125*^9}, {3.714253213451623*^9, 
   3.714253214323145*^9}},ExpressionUUID->"c31cd4b1-a5db-4d0c-9220-\
1c12f9a08105"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["L", "1"], ":", " ", "x"}], "=", 
    RowBox[{"3", "+", 
     RowBox[{"2", "t"}]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{"4", "-", "t"}]}], ",", " ", 
   RowBox[{"z", "=", 
    RowBox[{"1", "+", 
     RowBox[{"3", "t"}]}]}]}], TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["L", "2"], ":", " ", "x"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"4", "s"}]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{"3", "-", 
     RowBox[{"2", "s"}]}]}], ",", " ", 
   RowBox[{"z", "=", 
    RowBox[{"4", "+", 
     RowBox[{"5", "s"}]}]}]}], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"74b972b5-6922-497a-9392-11154e87d40b"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714253036660468*^9, 
  3.714253118949728*^9}},ExpressionUUID->"a74c82d3-b08c-42f7-ba6d-\
b5105ce7ca3a"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["L", "1"], ":", " ", "x"}], "=", 
    RowBox[{"5", "-", 
     RowBox[{"12", "t"}]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{"3", "+", 
     RowBox[{"9", "t"}]}]}], ",", " ", 
   RowBox[{"z", "=", 
    RowBox[{"1", "-", 
     RowBox[{"3", "t"}]}]}]}], TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["L", "2"], ":", " ", "x"}], "=", 
    RowBox[{"3", "+", 
     RowBox[{"8", "s"}]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"-", "6"}], "s"}]}], ",", " ", 
   RowBox[{"z", "=", 
    RowBox[{"7", "+", 
     RowBox[{"2", "s"}]}]}]}], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"bf73be94-c092-4ffd-9683-0860f1d0204e"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714253036660468*^9, 
  3.714253187395794*^9}},ExpressionUUID->"dd263013-b637-456e-8974-\
788d0c557baf"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["L", "1"], ":", " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["r", "^"], "1"], "(", "t", ")"}]}], " ", "=", " ", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"2", "+", "t"}], ",", 
     RowBox[{"3", "-", 
      RowBox[{"2", "t"}]}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"3", "t"}]}]}], "\[RightAngleBracket]"}]}], 
  TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["L", "2"], ":", " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["r", "^"], "2"], "(", "s", ")"}]}], "=", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"3", "+", "s"}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"3", "s"}]}], ",", 
     RowBox[{"2", "-", 
      RowBox[{"7", "s"}]}]}], "\[RightAngleBracket]"}]}], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"b7950053-737f-4505-a4f3-d2033f46e674"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714253036660468*^9, 3.7142531266931143`*^9}, {
  3.714253235581205*^9, 
  3.7142533551882143`*^9}},ExpressionUUID->"63e5d4f6-3525-472a-8824-\
9140112765f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147017331783*^9, 
  3.7147017353658743`*^9}},ExpressionUUID->"c32d6cb9-476b-4d67-b5f3-\
001307aa9d5a"],

Cell[CellGroupData[{

Cell["Part 1", "Subsubsection",
 CellChangeTimes->{{3.7147017331783*^9, 3.71470173402717*^9}, {
  3.714701778377775*^9, 
  3.714701781859311*^9}},ExpressionUUID->"519273bc-bcbd-4215-96a2-\
6a2315c43663"],

Cell[TextData[{
 "Check the direction vectors of the lines: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "1"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "832aba37-441e-4de9-b822-47d43d4e8abb"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "2"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", 
      RowBox[{"-", "2"}], ",", "5"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ae3de781-1150-4d3f-bd85-4cef4526b818"],
 ". In order for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "521c808c-605e-41ce-ac76-e32bfdda814e"],
 "-components of the vectors to match, we would need to multiply ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["v", "\[RightVector]"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "88ec1ff6-88d6-4350-a4da-79e1209ae2ba"],
 " by ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b42ba6ea-4fcf-4994-b55f-73fd4d1923fd"],
 ". The ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e09bd26d-f93f-4a39-bb65-65fc616efefa"],
 "-components will then also match, however the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4ed4ae55-73d3-46c6-8b61-916e14f0e2fb"],
 "-components will not match since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"6", "\[NotEqual]", "5"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1aa98c8a-eef1-4818-857f-58f7f77640d6"],
 ". So these vectors are not parallel, thus these lines are not parallel."
}], "Text",
 CellChangeTimes->{{3.7147018179779816`*^9, 3.7147019544467535`*^9}, {
  3.714702120662382*^9, 
  3.714702165206846*^9}},ExpressionUUID->"385d7021-18f5-4e3b-89b2-\
5317df219b58"],

Cell["\<\
Since the lines are not parallel, we check for intersections by setting the \
components of the lines equal to each other:\
\>", "Text",
 CellChangeTimes->{{3.7147018179779816`*^9, 3.7147019544467535`*^9}, {
  3.714702120662382*^9, 3.7147021318465595`*^9}, {3.7147021732461815`*^9, 
  3.7147021914290113`*^9}},ExpressionUUID->"dd2fc2b1-2d0c-4c79-af0f-\
f9e0724c67ae"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"3", "+", 
          RowBox[{"2", "t"}]}], "=", 
         RowBox[{"1", "+", 
          RowBox[{"4", "s"}]}]}]},
       {
        RowBox[{
         RowBox[{"4", "-", "t"}], "=", 
         RowBox[{"3", "-", 
          RowBox[{"2", "s"}]}]}]},
       {
        RowBox[{
         RowBox[{"1", "+", 
          RowBox[{"3", "t"}]}], "=", 
         RowBox[{"4", "+", 
          RowBox[{"5", "s"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"1d11fc60-a265-4857-a9e6-1f09bf05ca3e"]], \
"Text",
 CellChangeTimes->{{3.714702232986536*^9, 
  3.7147022609760847`*^9}},ExpressionUUID->"3848ade8-c33e-43b5-b23c-\
f045466f74a3"],

Cell[TextData[{
 "Solving the second equation for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "426b4eb9-440e-4c33-9ca8-8d768873b603"],
 " we get ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", "s"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0a831b20-1071-4a98-88a1-39aa1162c18c"],
 ", which we will plug into the first equation to get:"
}], "Text",
 CellChangeTimes->{{3.714702273569481*^9, 
  3.714702310433299*^9}},ExpressionUUID->"f3629d40-ab04-4929-8c5f-\
5f58ff80607b"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"3", "+", 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", "s"}]}], ")"}]}]}], "=", 
   RowBox[{"1", "+", 
    RowBox[{"4", "s"}]}]}], TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[DoubleLongRightArrow]", " ", "3"}], "+", "2", "+", 
    RowBox[{"4", "s"}]}], "=", 
   RowBox[{"1", "+", 
    RowBox[{"4", "s"}]}]}], TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{"\[DoubleLongRightArrow]", " ", "5"}], "=", "1"}], 
  TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"3cfabb5a-37b7-456b-b257-207aa7699b4d"]], \
"Text",
 CellChangeTimes->{{3.714702273569481*^9, 3.7147023956399946`*^9}},
 TextAlignment->Center,ExpressionUUID->"d91f63aa-6bf2-486d-b56e-15400c9e56c6"],

Cell["\<\
Since this cannot be true, we conclude that the lines are skew.\
\>", "Text",
 CellChangeTimes->{{3.7147024049998384`*^9, 
  3.7147024164152145`*^9}},ExpressionUUID->"93f65e8d-8e83-4293-837f-\
1104a096ef37"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 2", "Subsubsection",
 CellChangeTimes->{{3.7147017331783*^9, 3.71470173402717*^9}, {
  3.714701778377775*^9, 
  3.714701785130579*^9}},ExpressionUUID->"a3b4df27-22b8-40a6-a64e-\
c850fbae42bc"],

Cell[TextData[{
 "Check the direction vectors of the lines: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "1"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "12"}], ",", "9", ",", 
      RowBox[{"-", "3"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "00ae20c0-f911-4e37-8c6e-90de6248fae4"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "2"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"8", ",", 
      RowBox[{"-", "6"}], ",", "2"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d5481845-2c64-4232-a22d-af3adcd76998"],
 ". In order for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1e5b5c2b-4e06-4bd3-94c5-40cec4e8c858"],
 "-components of the vectors to match, we would need to multiply ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["v", "\[RightVector]"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "64df4f6b-6954-4769-9cd9-3f4e4be64083"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    StyleBox[
     FractionBox["3", "2"],
     FontSize->18]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3f771c08-6b2b-49b5-8110-caf79de34aa8"],
 ". The ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "72aff26d-bc54-4869-a88b-5373fcb0b91a"],
 "-components will then also match, and so will the the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "63a295d5-1596-4ccc-8b3e-08a37a12f386"],
 "-components. So the vectors are parallel, thus these lines are parallel."
}], "Text",
 CellChangeTimes->{{3.7147018073366556`*^9, 3.7147018134247327`*^9}, {
  3.7147019636059265`*^9, 
  3.7147020391353235`*^9}},ExpressionUUID->"b790048e-e154-43cb-8b35-\
b3923add8721"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 3", "Subsubsection",
 CellChangeTimes->{{3.7147017331783*^9, 3.71470173402717*^9}, {
  3.714701778377775*^9, 
  3.714701787473176*^9}},ExpressionUUID->"cfb3f874-f7df-45d2-840e-\
ce00cc4ad51f"],

Cell[TextData[{
 "Check the direction vectors of the lines: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "1"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", 
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "3"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "25cf5d1b-a44c-4760-8948-aa47f390762a"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["v", "\[RightVector]"], "2"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "3", ",", 
      RowBox[{"-", "7"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6f9c8261-a2b5-4827-a4aa-e799c1315745"],
 ". These already have the same ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c4726fbe-f21c-4e55-a685-4d81a1040bba"],
 "-components so since the other components are not equal, these vectors are \
not parallel, thus these lines are not parallel."
}], "Text",
 CellChangeTimes->{
  3.7147018200734167`*^9, {3.714701965221966*^9, 3.71470196552026*^9}, {
   3.7147020454388685`*^9, 
   3.7147021157904863`*^9}},ExpressionUUID->"78bc645d-431f-4e1d-b783-\
3acae55b964c"],

Cell["\<\
Since the lines are not parallel, we check for intersections as before:\
\>", "Text",
 CellChangeTimes->{{3.7147024281741815`*^9, 
  3.71470244563284*^9}},ExpressionUUID->"19b75dfa-b854-49cf-b4ce-\
e613ff3ac910"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"2", "+", "t"}], "=", 
         RowBox[{"3", "+", "s"}]}]},
       {
        RowBox[{
         RowBox[{"3", "-", 
          RowBox[{"2", "t"}]}], "=", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"3", "s"}]}]}]},
       {
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", "t"}]}], "=", 
         RowBox[{"2", "-", 
          RowBox[{"7", "s"}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"20ec76c6-71fa-4843-995b-947cfef8847e"]], \
"Text",
 CellChangeTimes->{{3.714702455528491*^9, 
  3.714702484567954*^9}},ExpressionUUID->"0b7597b7-644b-43e6-8b44-\
59595890767d"],

Cell[TextData[{
 "Solving the first equation for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6acb75c3-e1a9-4b4a-9b94-4009cb88dcc7"],
 " gives: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"1", "+", "s"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "90279a67-5b96-4e60-b194-0fe04dea7010"],
 ". Plugging this into the second equation, we have:"
}], "Text",
 CellChangeTimes->{{3.71470249344322*^9, 
  3.714702525303939*^9}},ExpressionUUID->"104a56da-747c-4889-a3e8-\
146522047729"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"3", "-", 
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s"}], ")"}]}]}], "=", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"3", "s"}]}]}]},
       {
        RowBox[{
         RowBox[{"3", "-", "2", "-", 
          RowBox[{"2", "s"}]}], "=", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"3", "s"}]}]}]},
       {
        RowBox[{
         RowBox[{"1", "+", "4"}], "=", 
         RowBox[{
          RowBox[{"2", "s"}], "+", 
          RowBox[{"3", "s"}]}]}]},
       {
        RowBox[{"5", "=", 
         RowBox[{"5", "s"}]}]},
       {
        RowBox[{"s", "=", "1"}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"c69702e3-6981-4303-83af-bcc60810205a"]], \
"Text",
 CellChangeTimes->{{3.7147025336473117`*^9, 
  3.714702590944539*^9}},ExpressionUUID->"1dd386bf-64f3-4fb5-a795-\
674b50f9e88c"],

Cell[TextData[{
 "We have obtained ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e4769407-23be-4ca8-9d0a-6a2f42b9b3cd"],
 " which gives that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{"1", "+", "s"}], "=", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "48471b92-82f6-4112-aac4-652d2aee71a5"],
 " from before. To see if this means the lines intersect, we must check these \
values of ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9a3cf44c-7f03-4880-adc1-e1afcd50601c"],
 " and ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "cad3dc28-3895-4536-97a6-4502f36dde58"],
 " in the remaining equation:"
}], "Text",
 CellChangeTimes->{{3.714702598572609*^9, 
  3.714702648330303*^9}},ExpressionUUID->"8bab7dc8-8c48-429b-8c3a-\
04bea72acd96"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", 
           RowBox[{"(", "2", ")"}]}]}], "=", 
         RowBox[{"2", "-", 
          RowBox[{"7", 
           RowBox[{"(", "1", ")"}]}]}]}]},
       {
        RowBox[{
         RowBox[{"1", "-", "6"}], "=", 
         RowBox[{"2", "-", "7"}]}]},
       {
        RowBox[{
         RowBox[{"-", "5"}], "=", 
         RowBox[{"-", "5"}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"8fc70dc4-c7b8-4fe1-a2bf-cb4103b7af1d"]], \
"Text",
 CellChangeTimes->{{3.714702671321023*^9, 
  3.7147027068501415`*^9}},ExpressionUUID->"74b480dc-3ffa-4733-9f6f-\
21abdaca93e4"],

Cell[TextData[{
 "So this checks out and we have that the lines intersect. To get the point \
of intersection either plug ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "2"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7ed59338-ee25-4056-97b8-3aba471f0fd7"],
 " into the first line or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b70d5ef3-bb4c-4d7d-8e29-878e35affb7b"],
 " into the second. Doing either one will show that the point of intersection \
is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"4", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "5"}]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "52039d29-eed5-40de-8aea-9e1bcf570114"],
 ". The angle of intersection is the same as the angle between the direction \
vectors of these lines, so the angle is"
}], "Text",
 CellChangeTimes->{{3.7147027093655443`*^9, 
  3.7147027950389338`*^9}},ExpressionUUID->"b363dd17-aed1-4237-b656-\
358c97a3ab52"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\[Theta]", "=", 
   RowBox[{
    RowBox[{"arccos", " ", 
     FractionBox[
      RowBox[{
       SubscriptBox[
        OverscriptBox["v", "\[RightVector]"], "1"], "\[CenterDot]", 
       SubscriptBox[
        OverscriptBox["v", "\[RightVector]"], "2"]}], 
      RowBox[{"||", 
       SubscriptBox[
        OverscriptBox["v", "\[RightVector]"], "1"], "||", " ", "||", 
       SubscriptBox[
        OverscriptBox["v", "\[RightVector]"], "2"], "||"}]]}], "=", 
    RowBox[{
     RowBox[{"arccos", " ", 
      FractionBox[
       RowBox[{"1", "-", "6", "+", "21"}], 
       RowBox[{
        SqrtBox[
         RowBox[{"1", "+", "4", "+", "9"}]], 
        SqrtBox[
         RowBox[{"1", "+", "9", "+", "49"}]]}]]}], "=", 
     RowBox[{"arccos", " ", 
      FractionBox["16", 
       RowBox[{
        SqrtBox["14"], 
        SqrtBox["59"]}]]}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"fd6442bc-2519-41ff-bf38-62e7763064cb"]], \
"Text",
 CellChangeTimes->{{3.7147027093655443`*^9, 3.714702926764331*^9}, {
  3.7147029834050255`*^9, 3.7147030011671085`*^9}},
 TextAlignment->Center,ExpressionUUID->"79cfed3f-c92b-4ddd-9d14-1bf8a89d7fd7"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7140619948143387`*^9, 
  3.71406199930182*^9}},ExpressionUUID->"51845899-4359-4829-b905-\
84276d313cc9"],

Cell[TextData[{
 "Find an equation for the plane which passes through the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"3", ",", "2", ",", "2"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d859991c-aa5f-457c-b055-5d890a5d747b"],
 " and is perpendicular to the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"4", "t"}], ",", 
      RowBox[{"1", "+", "t"}], ",", 
      RowBox[{
       RowBox[{"-", "3"}], "t"}]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f46822fe-3f48-40d6-9c75-3412001172d3"],
 ". At what point does the line ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["r", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "836f66a0-ad11-4740-be06-ba560ca43081"],
 " intersect the plane you just found?"
}], "Text",
 CellChangeTimes->{
  3.714254557382414*^9, {3.7142567514087563`*^9, 
   3.7142568440153804`*^9}},ExpressionUUID->"303a500f-0b90-4e66-b5e8-\
28ff00032114"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147004457055836`*^9, 
  3.714700448579379*^9}},ExpressionUUID->"52233758-5eb9-462a-8517-\
7dc082fd3f8a"],

Cell[TextData[{
 "Since the plane is perpendicular to the line, the vector normal to the line \
is the same as the direction vector of the line. Thus, we can use ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["n", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "1", ",", 
      RowBox[{"-", "3"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "75992936-4f36-4f49-9e41-ea2efdd0b104"],
 " as our normal vector and the point we are given to create the equation of \
the plane:"
}], "Text",
 CellChangeTimes->{{3.7147004457055836`*^9, 
  3.7147005183515096`*^9}},ExpressionUUID->"4531a21e-44bc-49ff-b187-\
9c9ca4810b99"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{"4", ",", "1", ",", "3"}], "\[RightAngleBracket]"}], 
          "\[CenterDot]", 
          RowBox[{"\[LeftAngleBracket]", 
           RowBox[{
            RowBox[{"x", "-", "3"}], ",", 
            RowBox[{"y", "-", "2"}], ",", 
            RowBox[{"z", "-", "2"}]}], "\[RightAngleBracket]"}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"="}}}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"4", 
         RowBox[{"(", 
          RowBox[{"x", "-", "3"}], ")"}]}], "+", 
        RowBox[{"(", 
         RowBox[{"y", "-", "2"}], ")"}], "+", 
        RowBox[{"3", 
         RowBox[{"(", 
          RowBox[{"z", "-", "2"}], ")"}]}]}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"4", "x"}], "-", "12", "+", "y", "-", "2", "+", 
         RowBox[{"3", "z"}], "-", "6"}], "=", 
        RowBox[{
         RowBox[{"4", "x"}], "+", "y", "+", 
         RowBox[{"3", "z"}], "-", "20"}]}]}]}]},
    {
     FrameBox[
      RowBox[{
       RowBox[{
        RowBox[{"4", "x"}], "+", "y", "+", 
        RowBox[{"3", "z"}]}], "=", "20"}]]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"78249454-a984-4d81-9147-9698ce9d0b42"]], \
"Text",
 CellChangeTimes->{{3.714700537085971*^9, 3.7147005898838987`*^9}, {
  3.714700723348879*^9, 
  3.7147008293543587`*^9}},ExpressionUUID->"00d0313b-32b6-4f22-9c39-\
47d57cfd1b8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9, {3.7140621526354446`*^9, 3.714062155403966*^9}, 
   3.7140622114516797`*^9},ExpressionUUID->"d2ec5041-3f61-4ae8-8bcc-\
02c6dd814afa"],

Cell[TextData[{
 "Find an equation for the plane which passes through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}], ",", "2"}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"08d0996b-198e-43f1-a90d-28b159281705"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1", ",", "5"}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"b7b5a65f-ed44-4611-9d17-14f125113f42"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", 
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "2"}]}], ")"}]}], TraditionalForm]],ExpressionUUID->
  "c3e8050f-e75e-4b95-bb6e-d52b13effade"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
   3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
   3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
   3.71364721831068*^9, 3.7136472292706084`*^9}, 3.7138335573096704`*^9, {
   3.713833824080535*^9, 3.7138338623458776`*^9}, 3.7138339340870676`*^9, {
   3.7140612265715113`*^9, 3.714061277211094*^9}, {3.714068124440487*^9, 
   3.714068133768079*^9}, {3.7142545621066675`*^9, 3.7142546339231057`*^9}, 
   3.7142568936071067`*^9, {3.714700910230632*^9, 
   3.7147009172491775`*^9}},ExpressionUUID->"91cc29f1-b22c-4cba-81b0-\
e0463167221e"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714700856533721*^9, 
  3.714700859295178*^9}},ExpressionUUID->"a06ab39b-92b5-4482-aa7b-\
29ce1f93aec5"],

Cell[TextData[{
 "The first step is to find a vector perpendicular to the plane. We can do \
this by making two vectors in the plane by connecting the three points, and \
then taking the cross product of those two vectors. Two vectors in the plane \
are: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["PQ", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"2", "-", "3"}], ",", 
       RowBox[{"1", "-", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ",", 
       RowBox[{"5", "-", "2"}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "3"}], "\[RightAngleBracket]"}]}]}],
    TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ed734898-40e7-47f7-9151-fc751d3b8298"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["PR", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"1", "-", "3"}], ",", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"-", "2"}], "-", "2"}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "4"}]}], "\[RightAngleBracket]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "96a9ec6b-ad97-4f1d-8ed1-0f9271bca910"],
 ", and now take the cross product to get a normal vector:"
}], "Text",
 CellChangeTimes->{{3.714700856533721*^9, 
  3.71470101280951*^9}},ExpressionUUID->"43ec5742-5fc4-40ac-b7d8-\
059385c48900"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["n", "\[RightVector]"], "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", GridBox[{
       {
        OverscriptBox["i", "^"], 
        OverscriptBox["j", "^"], 
        OverscriptBox["k", "^"]},
       {
        RowBox[{"-", "1"}], "2", "3"},
       {
        RowBox[{"-", "2"}], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "4"}]}
      }], "\[RightBracketingBar]"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "8"}], "-", 
        RowBox[{"(", 
         RowBox[{"-", "3"}], ")"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"(", 
           RowBox[{"-", "6"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"1", "-", 
        RowBox[{"(", 
         RowBox[{"-", "4"}], ")"}]}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "10"}], ",", "5"}], "\[RightAngleBracket]"}]}]}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"a2e6822c-5766-4e05-be48-7b2e0eb5872d"]], \
"Text",
 CellChangeTimes->{{3.714700856533721*^9, 3.714701148932768*^9}},
 TextAlignment->Center,ExpressionUUID->"f01964a5-f4a6-4d45-9de9-8404325ccb3c"],

Cell[TextData[{
 "Now we can use any of the three points above with the vector we found to \
create the equation of the plane (we\[CloseCurlyQuote]ll use ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3f5cf017-4330-46f1-85d9-37e683044183"],
 " here):"
}], "Text",
 CellChangeTimes->{{3.7147011623375816`*^9, 
  3.714701186336774*^9}},ExpressionUUID->"737d5841-fe89-4dde-8959-\
e49d12181f31"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "10"}], ",", "5"}], "\[RightAngleBracket]"}], 
    "\[CenterDot]", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"x", "-", "2"}], ",", 
      RowBox[{"y", "-", "1"}], ",", 
      RowBox[{"z", "-", "5"}]}], "\[RightAngleBracket]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}], "-", 
     RowBox[{"10", 
      RowBox[{"(", 
       RowBox[{"y", "-", "1"}], ")"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"(", 
       RowBox[{"z", "-", "5"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], "x"}], "+", "10", "-", 
      RowBox[{"10", "y"}], "+", "10", "+", 
      RowBox[{"5", "z"}], "-", "25"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], "x"}], "-", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"5", "z"}], "-", "5"}], "=", "0"}]}]}]}], 
  TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[DoubleLongRightArrow]", "  ", 
      RowBox[{"-", "5"}]}], "x"}], "-", 
    RowBox[{"10", "y"}], "+", 
    RowBox[{"5", "z"}]}], "=", "5"}], TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{"\[DoubleLongRightArrow]", "  ", 
   FrameBox[
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}], "-", "z"}], "=", 
     RowBox[{"-", "1"}]}]]}], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"14d6e633-6d1c-465c-8225-f7b1039cf611"]], \
"Text",
 CellChangeTimes->{{3.714700856533721*^9, 3.714701145312852*^9}, {
  3.7147011905395346`*^9, 3.7147012997786016`*^9}, {3.7147013299779096`*^9, 
  3.7147013417305427`*^9}, {3.714701528155505*^9, 3.714701528156006*^9}},
 TextAlignment->Center,ExpressionUUID->"a2f4063c-4e89-4492-b562-176bc73fc3e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.7142569274923954`*^9, 
  3.714256930117067*^9}},ExpressionUUID->"4d922783-feb0-4d5f-974a-\
929212b0088d"],

Cell["Use intercepts to help sketch the following plane by hand", "Text",
 CellChangeTimes->{{3.7142569274923954`*^9, 
  3.7142569600462046`*^9}},ExpressionUUID->"3ade9630-f9da-4e9d-8e49-\
fc49febf9e8c"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2", "x"}], "+", 
     RowBox[{"5", "y"}], "+", "z"}], "=", "10"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fe61d502-b621-461b-97eb-d61bea4ec6b5"],
 "."
}], "Text",
 CellChangeTimes->{{3.7142569274923954`*^9, 3.714256977658727*^9}},
 TextAlignment->Center,ExpressionUUID->"0b0d77b7-a173-4bac-818c-328553bb8841"],

Cell[TextData[{
 "Verify your sketch by using ",
 StyleBox["ContourPlot3D", "Code"],
 " to graph the plane. If one wanted to graph the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ax", "+", "by", "+", "cz"}], "=", "d"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6ba69b21-0d94-481c-a4ba-b89243067350"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "]"}], "\[Cross]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "]"}], "\[Cross]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5"}], "]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f680dfef-ef2c-4c55-b9ef-8ef9bc83fed0"],
 ", you would type the following code:\n",
 StyleBox["ContourPlot3D[ax+by+cz==d,{x,-5,5},{y,-5,5},{z,-5,5},Axes->True,\
AxesOrigin->{0,0,0},Boxed->False]\n", "Code"],
 StyleBox["Note the use of two equals signs when writing the equation of a \
plane. If you don\[CloseCurlyQuote]t do this, it will think you are defining \
a variable instead of writing an equation to graph.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.714256981577179*^9, 
  3.714257269528115*^9}},ExpressionUUID->"ab3d61f1-0d59-4195-b311-\
436d137fa3b5"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714699315639797*^9, 
  3.7146993289795303`*^9}},ExpressionUUID->"420273f7-7844-48fd-913f-\
b3067d045ef2"],

Cell[TextData[{
 "The intercepts are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"5", ",", "0", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "715bc3b7-3841-4821-9099-e0bcf1458e4f"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "2", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f4efc13d-4972-461f-abe7-134b825e7584"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0", ",", "10"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b34d573f-419a-45e5-8f7e-85d48c650db5"],
 ", and have been plotted below as large green dots."
}], "Text",
 CellChangeTimes->{{3.714699315639797*^9, 3.7146993556318836`*^9}, {
  3.7147016836512423`*^9, 
  3.714701690483982*^9}},ExpressionUUID->"deffa0fe-f392-4266-a521-\
116b8d4f1c91"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"5", "y"}], "+", "z"}], "\[Equal]", "10"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "11"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "2"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", "0.8", "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"PointSize", "[", ".05", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "10"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.714699363865202*^9, 3.7146995137319736`*^9}, {
  3.7147015433587713`*^9, 3.714701571308999*^9}, {3.7147016018483944`*^9, 
  3.714701704093215*^9}},ExpressionUUID->"947f5adf-9cea-4306-8482-\
ea89ef769f6e"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxlmns41Nv3x8dgxt3kHl2ISEeSiG58nNzqJJ0ORakQIhVdFNUJRfeLhFQI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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.8], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwt1QuQj1UYx/Hn/K27dc3msrss0mrksttgMW65m1xjGbd20VVWkUhIVGhy
mTREaSJkopuKGpcZU6iUmVJq0jQpXTCRMlNNxfc3zzPj4znn/N/3vOd9z3Oe
LSivGDkjY2avoBJGJLNRGIMe/HAbYyXEInSmXUzsQ+yL/uiCtuiE3vy2ltgr
rhmgMSzAPjyMR3EQi83nK8QgDES/uD6HZ9dBNioz182MVSFOJd6EInRDd3TF
NH5rhzLUpl8PNVCN/nhidWLVjK9Z84whlmK0+fitxFrEacRJmGD+3mWYjNOs
417it8Tbua49ylGXfn00QxNUQj4uYxb+xVqsw2bUQE1Ux1a8hC0Yim24BU2Z
tzKxMXEecRHmoiH9S6yhCfE5+hvwLFbhMxzGb7oPF/A/1yZiFs7R/h3/4HH6
y/BYPHcYRuMdfjuDAtqFuA4tY/7VWJl8PfPxRMx/Bf+Zv+MzWIH99PdiKe3Z
WBzfYirrbqV8wpSM700XJR5ytVbiCOIozDTfd+VDXeKp5Lmj7/8kcTmW4Qf6
TxN/JJ7BW9HWPGswHLvwGnabv+MevB35NgQPYSIOxL7X53nzlUPEOlor7ZrE
Blqzzkjkz/jIDeVzS/O90zVLaF+jvSM+gkXm89xPrE18gPggZiOb/qwY1xrG
Yaz5vdnKTfPvuRMvx7vswPY4Uwuxwvwb5ikQe2b8G/UjDkOx8orYgrHmyMeX
jPHPvuK/k8mfo3YDrV3fIM51CYp9eqtifk8pneWqDxkfz0JTdEBHtMdInSXt
A3EG/dWxp7n0OzJ+I3EL/U3YYH5NhfkZ+zvy6y/cQ3867kZD7YPOsvn5+yPm
+YbYiLGvk79jXqwnS/kW32SN8gQbcUn3xfxv4g3sQmd0QhGaKzd1rlU3dI6Z
pxrxKPEjfKrn4Xi0p6s+aL3J23fiLkzC2BhvhdbxbL1LjnntuoFnvMdYG9U5
4n3og3fxKnYmr8kvYnjUjReinqgGDsVgnKX/E/HXWOcxHDGvGzr7OcTPia9H
/l/Re0atyMUE1R4cwyf4OPn1l3FReUi/F4bgQ3yAIyjHZFQk/87Ho1bo7M/B
DtWK5HVO9fAL5R9OmP+teCrOpurnwahfqlfn9U7m809BWexLCbEg42vOS157
lSfv4w7z+rYkef1RPT+EOeZ7MRATtXb6h3HaPA+3YbN53eugPIr9ahs1ULmh
fOgR9z6Pjebv8rP5d1dtL8W1yeuc9q4w4zmvOtlIZxRtGM/P+P7uw97k52kB
DuAXiX3U38Huyf9eKN+74k/lEffvJl4ff4N6o1bsywntf/L8PIlTOJe8Tute
nYvWqlnE74jfx3dQe715Db0KmTXflQ==
            "]], Polygon3DBox[CompressedData["
1:eJwtl3f012MUxz/Ph0gyIpL9y0lRqBDRQktbZjJ/RnIQjnXQkswyT7KizkGy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            "]], Polygon3DBox[CompressedData["
1:eJxN1nccT1UYx/F7rpE9syUzm+y9VxnZe4vKCG1kFJVR2SMhIVv2lllmJbto
GFFEKhRC+nx7nj96vX7v1/mdc+8999xznjNydevXrG8cRdEsJMJ2DEejEEUL
sBAZueEPyi7jF2Qiv4d0Ot7DaZxDZe6thtZIhqRY4nW8jhex2Ot9Ai3xIRah
EXWWIi2JsrpOfiV1rsYFrMc6VOJalWDvyoiUqI26qINaqKnndS8qIqPaHFm9
5VDV61Bd1bEVG/GJt387siIH2qMLvuL5k/gO3+IUmlHeAs3RFE2wCquxFuux
Du3QFm3QCR1RgO9bTrrJ312QfB7qzIvG3j8ag0Lkv1Tf+vfUj6ydem4ZVmIn
Hub58v596sMc5DuQZtc1pPM2HOb59EiHIziE8ZSPwx58ioNoxfOjSbfhqNpM
fjfpfuzDAXyGL3h+Hw5G1kdq61DKl6rPMAEzgrVffZYcGXxcdH0qjvj7xyoe
KN8ZWXztxgwc8HZ+7WOgd+30b9+AmZiu9lDeG70wB7PVVxiCMdiCTdiFHuiA
bf4+pR3RBtM8tpdhK96g7hHIj5/JH8cxXMWveMzHtTee9VhU2gc90Qt9Nc7c
uxmj+P9WsHr/JH/UY3sDbmA5liKf4gS59V6c8Hf/pHlI/kl0Qz/UQ318hPmY
i2k+Dv09hjv7/V3RmPGsSHodxfn/VGzxmRbPeNv1PXcw2+uch3+CrRW7fc6f
xXnsx+c+VoqHvWhOnQ9yf3r0QDPyZyhfFdnc1nf/joe4Vho1kMbjNTH31lId
aIEHyLfES1wbEiw2W5Nf4mO60cdqEW5xbSReRTFcw/caE671wwDNY/LVeX4y
/9dgBWqTP0/5JP5P8XZeIH8G4/nfN7I6zgW7b62vf1PxI/l3ScdhMT72ek9T
/hrpQH2DYpj8N+AXJUaS/5XpekokwIlgbVI9Cz0eFBcLMA/vYybmqw+5twjy
oqh/700Mw0Dvi9v4Cy8HW4dfUOzhRrA4KIMYl3EpWIwp1i/hovffYJ9PE70P
JpA2Rf/I+mesYjNYTGhPWOv9d8vb9QiGe1s0rrV8PPp6HWno/zqaTxiEtOR/
4N6hPocH+7j9jTnB1txWuIcq3DuS613RBVXJ3/Xv1N6zyGP3Ha51R0lU09xG
48j2h5Q+TsMie3aez6dXvK+6+v2t0QqdEce2Zmvtzh6pIIpSKFb5W1cx5bFb
GSP4Pxpv693kf6POLMH2mx24j6SUt/f6VYfqyoprvjYk4p5sse3JWnu0Bula
BvIJkM/foXelJ58ZiTXHUQLZvb4k6sfI9nU925P0OfSJbA19Gqkof97LdC2l
f4fGQ+NSjP89/J3ZvQ90dnjdx3KAj6/GOZF/b07Foeao2q7+jWyd/sDjei6u
aH5ovPh/L7KYLK82x9Y/zSgrS3qI8sM4Fmxf2htsndba+qbmnceb1tH8Hn+a
I3k0+TzetfZoj8ymeUCd6WKLO8VfJfUx5QmCnQc0Vld9flzk+nXN+8jW4jqx
jeso7NDYk08e7ByUCZmRAamDnVt0NtJ1rY/am7XupUCqYGuw1txZmILJwdbz
u4ol0oTeP3fIPxpsj8jja0ChYOu+nhmjeA+2x16J7PymMb+Nm5gUbH/Wvqsz
wMRga6bWjAGa7xgULIbuRzYeeneW2PYqnclyeWwpxuqRb4gGPodroJvOjlwr
qL72faYUynHtcTRCafLtYjvP6EyUl//dcVLv5npWZMGpYPVpvyoaWzw3JO2E
s8HWX63nNWI78+mckTSyc63W1BSKS6RWbCMZSnBvQdICkbWpJPmE/r6cyI1s
kZ2vCgfbTyoojsmXobwoiqA8SqET2qFtZOcJnTHyce8K7981ikPyXWL7Tp0D
twQ7Xx0P9u7YwvO/PUCxrv1P66XW2iaaZ7GdPXVO1NqTkHwFb0NZVEF1VPVU
41LT16PCsZ3vdM7bpZghnwsNgp2Ly/u3FVNsobieiayPdF8Fj4nNijXt77Ht
cdrDkvia8y8FEW2N
            "]], 
           Polygon3DBox[{{518, 68, 66, 65, 69, 517}, {514, 29, 34, 30, 38, 
            516}, {526, 115, 117, 116, 99, 527}, {513, 6, 2, 27, 29, 512}, {
            569, 96, 95, 91, 520, 611}, {523, 94, 101, 118, 114, 527}, {557, 
            499, 500, 253, 255, 540}}]},
          Annotation[#, "Charting`Private`Tag$10670#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0b8rxGEcwPHn7CJ3clncWSxH1BlNMrhu8SOThePCwB3Jf8DA7ZIMwn+A
VRj8HE4GJWakDOpMcq9vhlfvej49T8/Tk55eGl2MhRAKNNHMC6888UALCeJU
ueWaPnrpidoQQrf2k2WGLTYYMFvXNVZZodFaWeeZo8gFB+xzxCHfvEVc8l2/
aLP3Qz/5oUbK/I8zSkxRIMcweZYpM8gQ0cMXKDLizFmN00qSHXY5ZdL8WE+4
546MtXO95IYrHqlSYZNt9vhlgjHG6bS3y707SNNOkufY/z/UASFZMpQ=
        "]]}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{475, 473, 474, 469, 470, 472, 471, 479, 609, 558, 478, 476, 
        477, 482, 480, 481, 606, 483, 484, 485, 486, 487, 490, 489, 488}], 
       Line3DBox[{509, 506, 507, 510, 508, 501, 502, 607, 503, 505, 504, 498, 
        496, 497, 610, 559, 499, 500, 491, 492, 493, 494, 495, 511}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{525, 526, 527, 523, 522, 611, 520, 521, 524, 519, 518, 517, 
        528, 529, 530, 558, 613, 532, 531, 515, 513, 512, 514, 516, 547, 
        546}], Line3DBox[{535, 534, 533, 538, 539, 537, 536, 540, 557, 559, 
        614, 541, 542, 543, 544, 545, 554, 553, 552, 548, 612, 549, 550, 551, 
        555, 556}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{560, 561, 562, 563, 564, 565, 571, 570, 609, 613, 572, 575, 
        581, 582, 601, 600, 596, 607, 597, 599, 598, 605, 608, 612, 602, 603, 
        604}], Line3DBox[{573, 574, 569, 611, 568, 566, 567, 578, 579, 606, 
        577, 576, 580, 583, 586, 587, 588, 610, 614, 591, 589, 590, 592, 585, 
        584, 595, 594, 593}]}}},
    VertexNormals->CompressedData["
1:eJzNWbFNBEEMPEETpDRBRoqIKYAACVLKueM/oQQq4MgogYQW6IGX/j9ZybJn
PN7bhBfWyue1Z8fj3eun14fni2maXg5/Lg+/bx/vd/Pjz7r+3l/d3vytx/+/
17mxz47d8oP6j/rx4mntnh80/h24L2t9Nh50v2j+Wf+Wn2geVHa2vqp99cY5
Wkd2vYUHFW9kv9vav072HYgTVR7YfVXHGc0/u16VN5SXVHnOxtnLruJnFX6y
PO/xQ5Rve+mZ0epedd5VdVHnGdVd+5P9s+kLVTqqWs+w/XSUfal4g62Xih9Q
nY/ylTrPUfxb61E+sfKjmqeq+3JvfKrwzPJM73mN7eMqHsieU9V5Z3GYPV9Z
HJ7nrKUY/6PWpXr+VfF8lP97zVmonsmuj+anql8sovxX9xdVn0XzaeUHxbOq
jha/sfFEdRSK8yqc9NL/1nctPETnOEvP9NI5W/V31K6OR41/z3/UDzvvq/g/
Gyd7HtHzksUDqjfYPFv7UvWL0XBi7RfNQ5V+ZvVt1X2Lyq7qv6y+rX5Hru7v
Kv2juo/aSs+w92+ePTsHVelkVV3Q+8AsPr34q+dEdL9o/0LjR/1Uz60oH26l
q1G71cd785t3P4Py8Gh5Q3mmigdYfFb77603UB3o7cvTw9k8V/O/Ok7vXKh1
ZhU/j8bnvXCI+rHqsjR29r2m9WOtP/tXvUta/qP7Qtez/S57Hr08R/O5N/yo
54XofeDWvJrVRdn8tHVHcavClYq3UZ7J4lld9+r7ARXfZnmMjT+bH4t/VH3B
48lon2JxbtUle468fpc9F16c0Xyi9zwWbtE8tO+DUZ7J6hlrX148KH7Q76re
ibz7Fq9/eXGiOER53orHep9C647eM6D5ieKKxS2q31AeQHmPfb9r6zhK32T9
/wPHm16M
     "]], 
   {RGBColor[0, 1, 0], PointSize[0.05], Point3DBox[{5, 0, 0}], 
    Point3DBox[{0, 2, 0}], Point3DBox[{0, 0, 10}]}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 1},
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{362.3723145913743, 387.8196581394024},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]]},
  PlotRange->{{-4, 6}, {-5, 5}, {-2, 11}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.8371426168790066`, 2.4554659904762577`, 1.4302425580513982`},
  ViewVertical->{-0.06718388939714018, 0.3129450559592437, 
   0.9473920608471122}]], "Output",
 CellChangeTimes->{{3.7146994256625395`*^9, 3.71469946366883*^9}, 
   3.714699514640622*^9, 3.7147015734612236`*^9, {3.714701608474676*^9, 
   3.7147017051449113`*^9}},ExpressionUUID->"ef291d34-5c95-4918-a30b-\
cbc93ac98242"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 3.7132360275922284`*^9}, 
   3.714062161219843*^9, {3.7140621964035716`*^9, 3.71406221565207*^9}, {
   3.71425727771903*^9, 
   3.714257277799074*^9}},ExpressionUUID->"75ef795d-ed94-4422-9b08-\
0272bd75d947"],

Cell["Find an equation for the plane which contains the lines:", "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}, {3.7138344195303154`*^9, 3.713834609225483*^9}, {
   3.7140618261807194`*^9, 3.7140619126224985`*^9}, {3.7142546806995754`*^9, 
   3.71425471008502*^9}, {3.714255378375185*^9, 3.7142553800083303`*^9}, {
   3.714255439480571*^9, 
   3.7142554520723405`*^9}},ExpressionUUID->"f98c3091-8a04-4079-a727-\
6e446025c34d"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["L", "1"], ":", " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["r", "\[RightVector]"], "1"], "(", "t", ")"}]}], " ", "=",
    " ", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"2", "+", "t"}], ",", 
     RowBox[{"3", "-", 
      RowBox[{"2", "t"}]}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"3", "t"}]}]}], "\[RightAngleBracket]"}]}], 
  TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["L", "2"], ":", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["r", "\[RightVector]"], "2"], "(", "s", ")"}]}], "=", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"3", "+", "s"}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"3", "s"}]}], ",", 
     RowBox[{"2", "-", 
      RowBox[{"7", "s"}]}]}], "\[RightAngleBracket]"}]}], 
  TraditionalForm]}],ExpressionUUID->"cd0a52fb-fe5b-4edf-ba21-219e39367040"]],\
 "Text",
 CellChangeTimes->{{3.7142555745596533`*^9, 3.7142555886671057`*^9}, {
  3.714703036253541*^9, 
  3.7147030403988314`*^9}},ExpressionUUID->"8487f24e-866e-40a2-87c4-\
cec37718ce94"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7147030169284596`*^9, 
  3.7147030251657853`*^9}},ExpressionUUID->"32efbbda-7cc6-4912-8b2b-\
77c854e7ef25"],

Cell["\<\
These are the lines from problem 4, part 3, so we know they intersect and \
hence they lie in the same plane. To get the perpendicular vector to the \
plane, we take the cross product of the direction vectors of these two lines:\
\>", "Text",
 CellChangeTimes->{{3.7147030169284596`*^9, 
  3.7147031294893694`*^9}},ExpressionUUID->"d92fc28c-8262-4ca6-8272-\
75cc1ae6ea91"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["n", "\[RightVector]"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}]}], "\[RightAngleBracket]"}], "\[Cross]", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "3", ",", 
       RowBox[{"-", "7"}]}], "\[RightAngleBracket]"}]}], "=", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", GridBox[{
        {
         OverscriptBox["i", "^"], 
         OverscriptBox["j", "^"], 
         OverscriptBox["k", "^"]},
        {"1", 
         RowBox[{"-", "2"}], 
         RowBox[{"-", "3"}]},
        {"1", "3", 
         RowBox[{"-", "7"}]}
       }], "\[RightBracketingBar]"}], "=", 
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"14", "-", 
         RowBox[{"(", 
          RowBox[{"-", "9"}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "-", 
           RowBox[{"(", 
            RowBox[{"-", "3"}], ")"}]}], ")"}]}], ",", 
        RowBox[{"3", "-", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}], "\[RightAngleBracket]"}], "=", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"23", ",", "4", ",", "5"}], "\[RightAngleBracket]"}]}]}]}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"d222b427-4a68-4a0d-8c39-05c07e4a4119"]], \
"Text",
 CellChangeTimes->{{3.7147030169284596`*^9, 3.7147032399353805`*^9}},
 TextAlignment->Center,ExpressionUUID->"2ecbf7d0-a296-4c8a-a82d-fee597bcecbc"],

Cell[TextData[{
 "Next we need a point on the plane. We can use the point of intersection \
that we found back in problem 4, or we can just pick any point from either \
line since the lines are contained in the plane. Let\[CloseCurlyQuote]s get a \
point by just plugging in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5aa5bcbb-d6bb-43d3-9ecd-16b131a306ce"],
 " into the first line to get the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "3", ",", "1"}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5bcb6482-c2e6-40ba-9f6b-e8026c678f52"],
 ", so we can make the equation of the plane as:"
}], "Text",
 CellChangeTimes->{{3.7147032518248715`*^9, 
  3.7147033543477817`*^9}},ExpressionUUID->"18d80082-bace-46e2-9668-\
d3e5cbfd02f8"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"23", ",", "4", ",", "5"}], "\[RightAngleBracket]"}], 
    "\[CenterDot]", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"x", "-", "2"}], ",", 
      RowBox[{"y", "-", "3"}], ",", 
      RowBox[{"z", "-", "1"}]}], "\[RightAngleBracket]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"23", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"(", 
       RowBox[{"y", "-", "3"}], ")"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"23", "x"}], "-", "46", "+", 
      RowBox[{"4", "y"}], "-", "12", "+", 
      RowBox[{"5", "z"}], "-", "5"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"23", "x"}], "+", 
       RowBox[{"4", "y"}], "+", 
       RowBox[{"5", "z"}], "-", "63"}], "=", "0"}]}]}]}], 
  TraditionalForm], "\[LineSeparator]", 
 FormBox[
  RowBox[{"\[DoubleLongRightArrow]", " ", 
   FrameBox[
    RowBox[{
     RowBox[{
      RowBox[{"23", "x"}], "+", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"5", "z"}]}], "=", "63"}]]}], TraditionalForm]}],
 FormatType->
  "TraditionalForm",ExpressionUUID->"ee2a524b-748e-4592-80a8-31449ebd469a"]], \
"Text",
 CellChangeTimes->{{3.7147032518248715`*^9, 3.714703484938074*^9}},
 TextAlignment->Center,ExpressionUUID->"676f4b28-d400-481a-bd3a-efa27dd9e01b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 9", "Section",
 CellChangeTimes->{{3.713236030488112*^9, 3.7132360333433156`*^9}, {
  3.7140622007312565`*^9, 3.714062218227213*^9}, {3.7142572801187043`*^9, 
  3.714257280238943*^9}, {3.7142575581607137`*^9, 
  3.714257574919856*^9}},ExpressionUUID->"a6641696-49ed-4d89-afd9-\
c4e1088f28cc"],

Cell[TextData[{
 "Find an equation of the plane that contains all points that are equidistant \
from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "2", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a131eab2-e227-4b55-8a15-dae0506b225c"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "2", ",", "2"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f0786f9b-e95e-46db-87ba-a8f4a68d7ea5"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.7132369632722015`*^9}, 
   3.7134689836990843`*^9, {3.713648970245249*^9, 3.7136489768366575`*^9}, {
   3.7136490086305647`*^9, 3.7136490799425354`*^9}, {3.7138348972093554`*^9, 
   3.7138350920889792`*^9}, {3.7140622232989607`*^9, 3.71406228622122*^9}, {
   3.7140623408122873`*^9, 3.7140623439171734`*^9}, {3.714068137920683*^9, 
   3.71406815064781*^9}, 3.714255382609887*^9, {3.71425771644884*^9, 
   3.714257720208747*^9}},ExpressionUUID->"77c45901-bfa0-47f9-a683-\
46ea722ba68f"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7146995395057693`*^9, 
  3.714699542021364*^9}},ExpressionUUID->"bbda49db-9532-4d0d-8a38-\
7c9f386f534b"],

Cell[TextData[{
 "Two facts are needed to find an equation for this plane: (1) the midpoint \
of these two points is on the plane and (2) the plane is perpendicular to the \
vector joining these two points. The midpoint is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox[
        FractionBox[
         RowBox[{"2", "+", "0"}], "2"],
        FontSize->18], ",", 
       StyleBox[
        FractionBox[
         RowBox[{"2", "+", "2"}], "2"],
        FontSize->18], ",", 
       StyleBox[
        FractionBox[
         RowBox[{"0", "+", "2"}], "2"],
        FontSize->18]}], ")"}], "=", 
     RowBox[{"(", 
      RowBox[{"1", ",", "2", ",", "1"}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "00048a71-e4fe-49c0-a8b2-4a47575267d2"],
 " and the vector joining the points is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"0", "-", "2"}], ",", 
       RowBox[{"2", "-", "2"}], ",", 
       RowBox[{"2", "-", "0"}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0", ",", "2"}], "\[RightAngleBracket]"}]}]}],
    TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "51091154-fcb5-4fec-b501-224f58779787"],
 ". Therefore, the equation of the plane is"
}], "Text",
 CellChangeTimes->{{3.7146995395057693`*^9, 3.7146996087867413`*^9}, {
  3.714699640643407*^9, 
  3.714699749589474*^9}},ExpressionUUID->"6ad65007-7d61-42d5-9370-\
db49173415a7"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "0", ",", "2"}], "\[RightAngleBracket]"}], 
    "\[CenterDot]", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"x", "-", "1"}], ",", 
      RowBox[{"y", "-", "2"}], ",", 
      RowBox[{"z", "-", "1"}]}], "\[RightAngleBracket]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], "+", 
     RowBox[{"0", 
      RowBox[{"(", 
       RowBox[{"y", "-", "2"}], ")"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "x"}], "+", "2", "+", 
      RowBox[{"2", "x"}], "-", "2"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "x"}], "+", 
       RowBox[{"2", "z"}]}], "=", "0"}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"1db70180-ba7f-4857-acaa-7d1cbbb34f67"]], \
"Text",
 CellChangeTimes->{{3.7146995395057693`*^9, 3.7146996087867413`*^9}, {
  3.714699640643407*^9, 3.7146998327028522`*^9}},
 TextAlignment->Center,ExpressionUUID->"2c7e848b-a373-409d-9750-164131048bf1"],

Cell[TextData[{
 "We can simplify the equation of this plane to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "-", "z"}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9341f1b5-3dc7-4275-8bff-82f77057a37d"],
 "."
}], "Text",
 CellChangeTimes->{{3.714699865795497*^9, 
  3.714699892917288*^9}},ExpressionUUID->"969de87f-945c-43ef-a20d-\
9f3f0dcdd2aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 10", "Section",
 CellChangeTimes->{{3.7132360358875327`*^9, 3.7132360371682196`*^9}, {
  3.7138351070164747`*^9, 3.7138351098009634`*^9}, {3.713835634716791*^9, 
  3.7138356364700127`*^9}, {3.7138359316568527`*^9, 3.71383593260792*^9}, {
  3.713872640299595*^9, 3.7138726413837233`*^9}, {3.714062357948083*^9, 
  3.7140623585406356`*^9}, {3.7142572824871874`*^9, 3.7142572827271447`*^9}, {
  3.7142575542011585`*^9, 
  3.714257577391324*^9}},ExpressionUUID->"ee2d4b4b-f134-44cc-8f39-\
6e7c4651e049"],

Cell[TextData[{
 "We have looked at two ways to write a line: a vector equation and \
parametric equations. A third way to write a line is known as the ",
 StyleBox["symmetric equations",
  FontSlant->"Italic"],
 " of a line. For a line which passes through the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"], ",", 
     SubscriptBox["z", "0"]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "290330b3-3305-4a9d-a756-d6312c95be98"],
 " and is parallel to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"a", ",", "b", ",", "c"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a6565fc2-f25e-4407-bc16-a331a6a3da31"],
 ", the symmetric equations are"
}], "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 3.7132381044433203`*^9}, {3.7136491318222866`*^9, 
  3.7136491741507063`*^9}, {3.713649210263423*^9, 3.7136492725515833`*^9}, {
  3.713835130857093*^9, 3.7138351684036684`*^9}, {3.7138352463860474`*^9, 
  3.713835255997469*^9}, {3.714062363084509*^9, 3.714062512766612*^9}, {
  3.714255651009398*^9, 3.7142557005379367`*^9}, {3.7142559349880924`*^9, 
  3.714255983203903*^9}},ExpressionUUID->"e0f1c262-609c-4afc-82ee-\
08e3b670aaab"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         StyleBox[
          RowBox[{
           FractionBox[
            RowBox[{"x", "-", 
             SubscriptBox["x", "0"]}], "a"], "=", 
           RowBox[{
            FractionBox[
             RowBox[{"y", "-", 
              SubscriptBox["y", "0"]}], "b"], "=", 
            FractionBox[
             RowBox[{"z", "-", 
              SubscriptBox["z", "0"]}], "c"]}]}],
          FontSize->24]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "."}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"82fd9725-321b-4704-8ec2-f21f17c5838a"]], \
"Text",
 CellChangeTimes->{{3.7142559916942854`*^9, 3.71425602557419*^9}, {
  3.714256068099656*^9, 
  3.714256068099656*^9}},ExpressionUUID->"6c1f20c9-cbd0-41a9-9a5c-\
24a677e432ef"],

Cell[TextData[{
 "(We will assume that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4fb01e73-4e8c-4f7d-9f9c-60e1f7b0bcec"],
 " for this problem. It is possible to write symmetric equations for a line \
where one or two of the components of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8865dcfa-9f05-4a17-b74a-cf209f54fd2a"],
 " are ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c28a4442-c269-472b-86da-1128bb636e02"],
 ", but we won\[CloseCurlyQuote]t worry about that here.)"
}], "Text",
 CellChangeTimes->{{3.7142560353626842`*^9, 
  3.714256123876769*^9}},ExpressionUUID->"6d369725-c088-4f0e-a343-\
83dc82f33558"],

Cell[CellGroupData[{

Cell[TextData[{
 "Write the parametric equations for a line which passes through the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"], ",", 
     SubscriptBox["z", "0"]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "87d21670-5857-45d0-88dc-89a188b336f6"],
 " and is parallel to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"a", ",", "b", ",", "c"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b775761f-daa9-4eca-875d-486bb7cc8267"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 
  3.7142561777353835`*^9}},ExpressionUUID->"7a4fb80d-9c64-4360-8505-\
d22f7193594c"],

Cell[TextData[{
 "Solve for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2e1d8eab-56f4-423a-8043-8b328486aa5b"],
 " in each of the three equations (this is why we assume ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c2f6dd13-965e-42d0-948c-0d0043a944ed"],
 ")."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 
  3.714256214534579*^9}},ExpressionUUID->"fc1c177c-bdab-4ee1-8625-\
1ec725338b2e"],

Cell[TextData[{
 "Set all three expressions for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "744fc2c5-24ea-458f-9f89-a7fcb8a014cf"],
 " equal to each other to derive the symmetric equations above."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 
  3.7142562457596264`*^9}},ExpressionUUID->"92ca2a1e-dbd6-4ad2-b469-\
7dfc2e6a8382"],

Cell[TextData[{
 "Find the symmetric equations for the line passing through ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "2"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "09a3bb25-494a-4e2b-9ecd-1e3dce8448be"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "3"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4d5c1f8a-71a8-4bac-91a5-098c6469f253"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 
  3.7142563332785425`*^9}},ExpressionUUID->"81555ab1-d5c7-492c-91e3-\
456fe0ae389e"]
}, Open  ]],

Cell[TextData[{
 "This may seem like an odd way to express a line, but it can be useful when \
finding the line of intersection between two planes. This is also the \
preferred way to express a line in the mathematical area known as ",
 StyleBox["Algebraic Geometry",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.7142563498329077`*^9, 
  3.7142564735908375`*^9}},ExpressionUUID->"599e9da5-d092-4aeb-923d-\
17da203077df"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714699900628436*^9, 
  3.7146999037183857`*^9}},ExpressionUUID->"d721dd7d-7d0e-465f-8398-\
e8c60fcf32b1"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"], ",", 
        SubscriptBox["z", "0"]}], "\[RightAngleBracket]"}], "+", 
      RowBox[{"t", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"a", ",", "b", ",", "c"}], "\[RightAngleBracket]"}]}]}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "0"], "+", "at"}], ",", 
       RowBox[{
        SubscriptBox["y", "0"], "+", "bt"}], ",", 
       RowBox[{
        SubscriptBox["z", "0"], "+", "ct"}]}], "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]],ExpressionUUID->"3d22c948-714c-456c-96e5-4f4aeddd316c"],
 ", so the parametric equations are ",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{"x", "=", 
       RowBox[{
        SubscriptBox["x", "0"], "+", "at"}]}]},
     {
      RowBox[{"y", "=", 
       RowBox[{
        SubscriptBox["y", "0"], "+", "bt"}]}]},
     {
      RowBox[{"z", "=", 
       RowBox[{
        SubscriptBox["z", "0"], "+", "ct"}]}]}
    }], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4e71a28f-ad83-4000-9306-ec983b5a027a"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 3.7142561777353835`*^9}, {
  3.714699922941742*^9, 
  3.7147000228303347`*^9}},ExpressionUUID->"e6248d92-b38c-414a-9e90-\
f521efe15171"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{"x", "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "0"], "+", 
        RowBox[{"at", "\[DoubleLongRightArrow]", "t"}]}], "=", 
       StyleBox[
        FractionBox[
         RowBox[{"x", "-", 
          SubscriptBox["x", "0"]}], "a"],
        FontSize->18]}]}]},
    {
     RowBox[{"y", "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["y", "0"], "+", 
        RowBox[{"bt", "\[DoubleLongRightArrow]", "t"}]}], "=", 
       StyleBox[
        FractionBox[
         RowBox[{"y", "-", 
          SubscriptBox["y", "0"]}], "b"],
        FontSize->18]}]}]},
    {
     RowBox[{"z", "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["z", "0"], "+", 
        RowBox[{"ct", "\[DoubleLongRightArrow]", "t"}]}], "=", 
       StyleBox[
        FractionBox[
         RowBox[{"z", "-", 
          SubscriptBox["z", "0"]}], "c"],
        FontSize->18]}]}]}
   }], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"528f6902-1f30-4bde-8104-b19a12284ad1"]], \
"ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 3.714256214534579*^9}, {
  3.714699982541277*^9, 3.714699989268798*^9}, {3.714700042817856*^9, 
  3.7147000952313576`*^9}},ExpressionUUID->"8723cd4c-d038-4803-ba80-\
82ceec8607f8"],

Cell[TextData[{
 "Stringing the equalities together (since they\[CloseCurlyQuote]re all equal \
to ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "994dee96-13cc-4d66-af6e-ef73041b2629"],
 ") we get ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", GridBox[{
      {
       StyleBox[
        RowBox[{
         FractionBox[
          RowBox[{"x", "-", 
           SubscriptBox["x", "0"]}], "a"], "=", 
         RowBox[{
          FractionBox[
           RowBox[{"y", "-", 
            SubscriptBox["y", "0"]}], "b"], "=", 
          FractionBox[
           RowBox[{"z", "-", 
            SubscriptBox["z", "0"]}], "c"]}]}],
        FontSize->18]}
     },
     GridBoxAlignment->{"Columns" -> {{"Center"}}}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "76bcfdbf-99f2-40ed-a26d-be697eb5a9b7"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 3.7142562457596264`*^9}, {
  3.7147001164715967`*^9, 
  3.7147001536713514`*^9}},ExpressionUUID->"70e50152-e7ac-461d-8bd6-\
9767bf553783"],

Cell[TextData[{
 "Find the vector between the two points to get the direction of the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ",", 
       RowBox[{"0", "-", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}]}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f1e9c8ea-f470-4581-b568-f550f340db6c"],
 ". Use this and either of the points (we used the second in this solution) \
to create the symmetric equations: ",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      StyleBox[
       RowBox[{
        FractionBox[
         RowBox[{"x", "-", "1"}], "2"], "=", 
        RowBox[{
         FractionBox["y", 
          RowBox[{"-", "2"}]], "=", 
         FractionBox[
          RowBox[{"z", "+", "3"}], 
          RowBox[{"-", "1"}]]}]}],
       FontSize->24]}
    },
    GridBoxAlignment->{"Columns" -> {{"Center"}}}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d1dad840-2ee8-4b43-a9a3-34db6c6208d7"],
 " which can be simplified to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     FractionBox[
      RowBox[{"x", "-", "1"}], "2"],
     FontSize->24], 
    StyleBox["=",
     FontSize->24], 
    RowBox[{
     StyleBox[
      RowBox[{"-", 
       FractionBox["y", "2"]}],
      FontSize->24], 
     StyleBox["=",
      FontSize->24], 
     StyleBox[
      RowBox[{
       RowBox[{"-", "z"}], "-", "3"}],
      FontSize->16]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "cd6ede95-3769-4885-a942-19d3edc205f9"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.714256152604562*^9, 3.7142563332785425`*^9}, {
  3.714700165935672*^9, 
  3.714700381889398*^9}},ExpressionUUID->"3d2c00fc-99d0-46fb-afd7-\
25afb1c7ed90"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 231, 4, 101, "Title", "ExpressionUUID" -> \
"fec8a4e1-8cbe-4e8a-b6ac-fefebd952c63"],
Cell[CellGroupData[{
Cell[836, 30, 580, 11, 115, "Chapter", "ExpressionUUID" -> \
"530f7165-3028-4267-8d07-9ab8a3c7ca4a"],
Cell[1419, 43, 383, 7, 30, "Text", "ExpressionUUID" -> \
"089197c4-ddb5-4219-9e80-92b8e28adb0c"],
Cell[CellGroupData[{
Cell[1827, 54, 397, 10, 22, "Code", "ExpressionUUID" -> \
"f1b73c6d-03af-4e1c-b0a7-3c3a9a455888",
 CellOpen->False],
Cell[2227, 66, 855, 22, 30, "Output", "ExpressionUUID" -> \
"349dc998-50ff-45d9-9c2c-a890248307b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3119, 93, 207, 4, 70, "Section", "ExpressionUUID" -> \
"9f230656-6fe2-46d5-8ee8-69710d7e356a"],
Cell[3329, 99, 1265, 31, 34, "Text", "ExpressionUUID" -> \
"7ad245d3-85a1-4363-825d-f9ac12fa453d"],
Cell[CellGroupData[{
Cell[4619, 134, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"4bf7bcf4-5476-4255-a4c3-7b2a0d770634"],
Cell[4780, 139, 941, 27, 33, "Text", "ExpressionUUID" -> \
"4999fec4-8695-4222-a2a1-7054add3539a"],
Cell[5724, 168, 922, 26, 33, "Text", "ExpressionUUID" -> \
"bc68ab0f-4e76-4c06-8431-8e7c6bb878b4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6695, 200, 158, 3, 70, "Section", "ExpressionUUID" -> \
"6b157189-0885-4587-a931-c6550d743de6"],
Cell[6856, 205, 1446, 31, 30, "Text", "ExpressionUUID" -> \
"44e048d0-9c5e-4858-a8ac-e93277be3c9e"],
Cell[CellGroupData[{
Cell[8327, 240, 155, 3, 49, "Subsection", "ExpressionUUID" -> \
"3a6c5313-a2da-44a5-9d93-70c3f1d13719"],
Cell[8485, 245, 927, 28, 30, "Text", "ExpressionUUID" -> \
"76255cbe-75ce-4d23-8269-87ea14953e78"],
Cell[9415, 275, 908, 24, 33, "Text", "ExpressionUUID" -> \
"efcbeef3-675a-48f7-a453-9d0214f17f1f"],
Cell[10326, 301, 269, 5, 30, "Text", "ExpressionUUID" -> \
"71f4c264-fafb-417d-93b5-eb029b4c81d3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10644, 312, 156, 3, 70, "Section", "ExpressionUUID" -> \
"7d215477-cfdd-4460-8a71-b5044e3c9dd9"],
Cell[10803, 317, 1660, 36, 33, "Text", "ExpressionUUID" -> \
"12011e74-07b2-4fe3-9a62-f9490102548a",
 InitializationCell->True],
Cell[12466, 355, 687, 20, 72, "Text", "ExpressionUUID" -> \
"4eb59495-f678-491a-bc1f-f375e47d108d"],
Cell[13156, 377, 687, 19, 33, "Text", "ExpressionUUID" -> \
"179c5019-4bbb-4f05-845e-6db447c438f9"],
Cell[13846, 398, 694, 21, 72, "Text", "ExpressionUUID" -> \
"81f7f68e-8fc0-4c16-afbb-61646ed43d52"],
Cell[CellGroupData[{
Cell[14565, 423, 1083, 25, 30, "ItemNumbered", "ExpressionUUID" -> \
"45b5619b-d462-4cea-bb27-3875f48f3570"],
Cell[15651, 450, 771, 22, 30, "ItemNumbered", "ExpressionUUID" -> \
"0353805b-4e4d-4f13-bf53-f43fae928853"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16459, 477, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"d56d0594-95a5-4282-9b1a-dacc59432eac"],
Cell[CellGroupData[{
Cell[16642, 484, 2470, 74, 95, "ItemNumbered", "ExpressionUUID" -> \
"96f8c91c-aa32-4324-b32f-2f9b56165e21"],
Cell[19115, 560, 1937, 57, 88, "ItemNumbered", "ExpressionUUID" -> \
"4b019e64-32dc-47ae-b96d-ec24d5de2ecc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21113, 624, 208, 4, 70, "Section", "ExpressionUUID" -> \
"ba2929e7-e9f9-432b-86e8-682e343579f7"],
Cell[21324, 630, 960, 16, 30, "Text", "ExpressionUUID" -> \
"dc1b3740-0ca3-40b5-a6ee-92b169919b06"],
Cell[CellGroupData[{
Cell[22309, 650, 946, 31, 52, "ItemNumbered", "ExpressionUUID" -> \
"d4e48f16-ff10-4358-aa16-67f4fb01b4ce"],
Cell[23258, 683, 963, 32, 52, "ItemNumbered", "ExpressionUUID" -> \
"d24c2682-adb6-415a-b47a-8698453069a4"],
Cell[24224, 717, 1191, 37, 52, "ItemNumbered", "ExpressionUUID" -> \
"3dc273d9-0167-48b5-bad3-bb1d64488c4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25452, 759, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"c32d6cb9-476b-4d67-b5f3-001307aa9d5a"],
Cell[CellGroupData[{
Cell[25633, 766, 203, 4, 39, "Subsubsection", "ExpressionUUID" -> \
"519273bc-bcbd-4215-96a2-6a2315c43663"],
Cell[25839, 772, 2184, 63, 52, "Text", "ExpressionUUID" -> \
"385d7021-18f5-4e3b-89b2-5317df219b58"],
Cell[28026, 837, 377, 7, 30, "Text", "ExpressionUUID" -> \
"dd2fc2b1-2d0c-4c79-af0f-f9e0724c67ae"],
Cell[28406, 846, 843, 29, 68, "Text", "ExpressionUUID" -> \
"3848ade8-c33e-43b5-b23c-f045466f74a3"],
Cell[29252, 877, 611, 18, 30, "Text", "ExpressionUUID" -> \
"f3629d40-ab04-4929-8c5f-5f58ff80607b"],
Cell[29866, 897, 844, 25, 71, "Text", "ExpressionUUID" -> \
"d91f63aa-6bf2-486d-b56e-15400c9e56c6"],
Cell[30713, 924, 217, 5, 30, "Text", "ExpressionUUID" -> \
"93f65e8d-8e83-4293-837f-1104a096ef37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30967, 934, 203, 4, 39, "Subsubsection", "ExpressionUUID" -> \
"a3b4df27-22b8-40a6-a64e-c850fbae42bc"],
Cell[31173, 940, 2080, 61, 66, "Text", "ExpressionUUID" -> \
"b790048e-e154-43cb-8b35-b3923add8721"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33290, 1006, 203, 4, 39, "Subsubsection", "ExpressionUUID" -> \
"cfb3f874-f7df-45d2-840e-ce00cc4ad51f"],
Cell[33496, 1012, 1314, 36, 52, "Text", "ExpressionUUID" -> \
"78bc645d-431f-4e1d-b783-3acae55b964c"],
Cell[34813, 1050, 222, 5, 30, "Text", "ExpressionUUID" -> \
"19b75dfa-b854-49cf-b4ce-e613ff3ac910"],
Cell[35038, 1057, 841, 29, 68, "Text", "ExpressionUUID" -> \
"0b7597b7-644b-43e6-8b44-59595890767d"],
Cell[35882, 1088, 586, 17, 30, "Text", "ExpressionUUID" -> \
"104a56da-747c-4889-a3e8-146522047729"],
Cell[36471, 1107, 1107, 39, 106, "Text", "ExpressionUUID" -> \
"1dd386bf-64f3-4fb5-a795-674b50f9e88c"],
Cell[37581, 1148, 995, 30, 30, "Text", "ExpressionUUID" -> \
"8bab7dc8-8c48-429b-8c3a-04bea72acd96"],
Cell[38579, 1180, 819, 28, 68, "Text", "ExpressionUUID" -> \
"74b480dc-3ffa-4733-9f6f-21abdaca93e4"],
Cell[39401, 1210, 1101, 30, 49, "Text", "ExpressionUUID" -> \
"b363dd17-aed1-4237-b656-358c97a3ab52"],
Cell[40505, 1242, 1213, 35, 51, "Text", "ExpressionUUID" -> \
"79cfed3f-c92b-4ddd-9d14-1bf8a89d7fd7"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41779, 1284, 155, 3, 70, "Section", "ExpressionUUID" -> \
"e836f5b5-be67-4287-9bde-cfea9fe6c21f"],
Cell[41937, 1289, 1172, 34, 52, "Text", "ExpressionUUID" -> \
"2bacaa3e-2a80-429a-b05d-5bc2f37fa8e0"],
Cell[CellGroupData[{
Cell[43134, 1327, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"52233758-5eb9-462a-8517-7dc082fd3f8a"],
Cell[43295, 1332, 720, 17, 52, "Text", "ExpressionUUID" -> \
"4531a21e-44bc-49ff-b187-9c9ca4810b99"],
Cell[44018, 1351, 1552, 47, 64, "Text", "ExpressionUUID" -> \
"00d0313b-32b6-4f22-9c39-47d57cfd1b8e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45619, 1404, 257, 4, 70, "Section", "ExpressionUUID" -> \
"99bba69a-7be8-4730-a404-76f043b339c6"],
Cell[45879, 1410, 1425, 36, 30, "Text", "ExpressionUUID" -> \
"91cc29f1-b22c-4cba-81b0-e0463167221e"],
Cell[CellGroupData[{
Cell[47329, 1450, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"a06ab39b-92b5-4482-aa7b-29ce1f93aec5"],
Cell[47488, 1455, 1742, 49, 73, "Text", "ExpressionUUID" -> \
"43ec5742-5fc4-40ac-b7d8-059385c48900"],
Cell[49233, 1506, 1327, 41, 73, "Text", "ExpressionUUID" -> \
"f01964a5-f4a6-4d45-9de9-8404325ccb3c"],
Cell[50563, 1549, 448, 11, 30, "Text", "ExpressionUUID" -> \
"737d5841-fe89-4dde-8959-e49d12181f31"],
Cell[51014, 1562, 1969, 60, 85, "Text", "ExpressionUUID" -> \
"a2f4063c-4e89-4492-b562-176bc73fc3e3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53032, 1628, 156, 3, 70, "Section", "ExpressionUUID" -> \
"4d922783-feb0-4d5f-974a-929212b0088d"],
Cell[53191, 1633, 203, 3, 30, "Text", "ExpressionUUID" -> \
"e39a7b08-bc3a-4113-90eb-c791eee4ed66"],
Cell[53397, 1638, 422, 12, 30, "Text", "ExpressionUUID" -> \
"f02b8ff5-d104-49c0-ab32-53c70d3c1fed"],
Cell[53822, 1652, 1312, 35, 87, "Text", "ExpressionUUID" -> \
"da9bfe12-b63f-49b2-8334-97387dc13025"],
Cell[CellGroupData[{
Cell[55159, 1691, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"420273f7-7844-48fd-913f-b3067d045ef2"],
Cell[55320, 1696, 903, 27, 30, "Text", "ExpressionUUID" -> \
"deffa0fe-f392-4266-a521-116b8d4f1c91"],
Cell[CellGroupData[{
Cell[56248, 1727, 1764, 47, 88, "Input", "ExpressionUUID" -> \
"947f5adf-9cea-4306-8482-ea89ef769f6e"],
Cell[58015, 1776, 19362, 337, 403, "Output", "ExpressionUUID" -> \
"ef291d34-5c95-4918-a30b-cbc93ac98242"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77438, 2120, 279, 5, 70, "Section", "ExpressionUUID" -> \
"010ec998-df0e-431b-b403-3bba2bc53333"],
Cell[77720, 2127, 866, 12, 30, "Text", "ExpressionUUID" -> \
"9737f451-8fd5-4577-a247-2d87b85e53d2"],
Cell[78589, 2141, 1178, 37, 57, "Text", "ExpressionUUID" -> \
"8487f24e-866e-40a2-87c4-cec37718ce94"],
Cell[CellGroupData[{
Cell[79792, 2182, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"32efbbda-7cc6-4912-8b2b-77c854e7ef25"],
Cell[79955, 2187, 382, 7, 49, "Text", "ExpressionUUID" -> \
"d92fc28c-8262-4ca6-8272-75cc1ae6ea91"],
Cell[80340, 2196, 1618, 47, 73, "Text", "ExpressionUUID" -> \
"2ecbf7d0-a296-4c8a-a82d-fee597bcecbc"],
Cell[81961, 2245, 903, 22, 49, "Text", "ExpressionUUID" -> \
"18d80082-bace-46e2-9668-d3e5cbfd02f8"],
Cell[82867, 2269, 1488, 46, 65, "Text", "ExpressionUUID" -> \
"676f4b28-d400-481a-bd3a-efa27dd9e01b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84404, 2321, 306, 5, 70, "Section", "ExpressionUUID" -> \
"6f6f19ff-9b9a-4474-9491-8f390c59c70d"],
Cell[84713, 2328, 1060, 25, 30, "Text", "ExpressionUUID" -> \
"68be761e-4557-47bf-84c1-c927d60f49bd"],
Cell[CellGroupData[{
Cell[85798, 2357, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"bbda49db-9532-4d0d-8a38-7c9f386f534b"],
Cell[85959, 2362, 1650, 48, 66, "Text", "ExpressionUUID" -> \
"6ad65007-7d61-42d5-9370-db49173415a7"],
Cell[87612, 2412, 1294, 40, 30, "Text", "ExpressionUUID" -> \
"2c7e848b-a373-409d-9750-164131048bf1"],
Cell[88909, 2454, 399, 12, 30, "Text", "ExpressionUUID" -> \
"969de87f-945c-43ef-a20d-9f3f0dcdd2aa"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89357, 2472, 513, 8, 70, "Section", "ExpressionUUID" -> \
"b27bca88-110d-47f2-9f04-f3325b2835df"],
Cell[89873, 2482, 1447, 34, 52, "Text", "ExpressionUUID" -> \
"5795d4a0-00d2-4e20-a7b4-570864cee26f"],
Cell[91323, 2518, 896, 28, 50, "Text", "ExpressionUUID" -> \
"6c1f20c9-cbd0-41a9-9a5c-24a677e432ef"],
Cell[92222, 2548, 898, 24, 52, "Text", "ExpressionUUID" -> \
"f0a8ed23-ddcf-48bb-9816-1ce588386b15"],
Cell[CellGroupData[{
Cell[93145, 2576, 851, 25, 32, "ItemNumbered", "ExpressionUUID" -> \
"21e1fbb9-33a0-43f7-b9ac-f6f309c56998"],
Cell[93999, 2603, 593, 17, 30, "ItemNumbered", "ExpressionUUID" -> \
"e91634ba-c8fe-419e-898e-92a347451777"],
Cell[94595, 2622, 404, 10, 30, "ItemNumbered", "ExpressionUUID" -> \
"a0fd15be-0891-4fb0-9b86-38feeed1b770"],
Cell[95002, 2634, 704, 22, 30, "ItemNumbered", "ExpressionUUID" -> \
"1073e89f-11c4-4f3b-8dec-9f3d1a07bb5b"]
}, Open  ]],
Cell[95721, 2659, 438, 10, 49, "Text", "ExpressionUUID" -> \
"553d4ec5-01ba-42b2-8c76-006a578db9f6"],
Cell[CellGroupData[{
Cell[96184, 2673, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"d721dd7d-7d0e-465f-8398-e8c60fcf32b1"],
Cell[CellGroupData[{
Cell[96367, 2680, 1535, 48, 68, "ItemNumbered", "ExpressionUUID" -> \
"e6248d92-b38c-414a-9e90-f521efe15171"],
Cell[97905, 2730, 1301, 42, 110, "ItemNumbered", "ExpressionUUID" -> \
"8723cd4c-d038-4803-ba80-82ceec8607f8"],
Cell[99209, 2774, 1080, 34, 42, "ItemNumbered", "ExpressionUUID" -> \
"70e50152-e7ac-461d-8bd6-9767bf553783"],
Cell[100292, 2810, 2155, 71, 71, "ItemNumbered", "ExpressionUUID" -> \
"3d2c00fc-99d0-46fb-afd7-25afb1c7ed90"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

